<?php

/**
 * Breadcrumbs for Mykd Theme.
 *
 * @package     mykd
 * @author      ThemeDox
 * @copyright   Copyright (c) 2023, ThemeDox
 * @link        https://themeadox.com
 * @since       mykd 1.0.0
 */


function mykd_breadcrumb_func()
{
    global $post;
    $breadcrumb_class = '';
    $breadcrumb_show = 1;

    if (is_front_page() && is_home()) {
        $title = get_theme_mod('breadcrumb_blog_title', __('Blog', 'mykd'));
        $breadcrumb_class = 'home_front_page';
    }
    elseif (is_front_page()) {
        $title = get_theme_mod('breadcrumb_blog_title', __('Blog', 'mykd'));
        $breadcrumb_show = 0;
    }
    elseif (is_home()) {
        if (get_option('page_for_posts')) {
            $title = get_the_title(get_option('page_for_posts'));
        }
    }
    elseif (is_single() && 'post' == get_post_type()) {
        $title = get_the_title();
        $breadcrumb_class = 'breadcrumb__hide-img';
    }
    elseif (is_single() && 'services' == get_post_type()) {
        $title = get_the_title();
        $breadcrumb_class = 'breadcrumb__hide-img';
    }
    elseif (is_search()) {
        $title = esc_html__('Search Results for : ', 'mykd') . get_search_query();
    }
    elseif (is_404()) {
        $title = esc_html__('Page not Found', 'mykd');
    }
    elseif (function_exists('is_woocommerce') && is_woocommerce()) {
        $title = get_theme_mod('breadcrumb_shop', __('Shop', 'mykd'));
    }
    elseif (is_archive()) {
        $title = get_the_archive_title();
    }
    else {
        $title = get_the_title();
    }

    $_id = get_the_ID();

    if (is_single() && 'product' == get_post_type()) {
        $_id = $post->ID;
        $title = get_theme_mod('breadcrumb_shop_single', __('Product Single', 'mykd'));
        $breadcrumb_class = 'breadcrumb__hide-img';
    }
    elseif (function_exists("is_shop") and is_shop()) {
        $_id = wc_get_page_id('shop');
    }
    elseif (is_home() && get_option('page_for_posts')) {
        $_id = get_option('page_for_posts');
    }

    $is_breadcrumb = function_exists('get_field') ? get_field('is_it_invisible_breadcrumb', $_id) : '';
    if (!empty($_GET['s'])) {
        $is_breadcrumb = null;
    }

    if (empty($is_breadcrumb) && $breadcrumb_show == 1) {

        $bg_img_from_page = function_exists('get_field') ? get_field('breadcrumb_background_image', $_id) : '';
        $hide_bg_img = function_exists('get_field') ? get_field('hide_breadcrumb_background_image', $_id) : '';

        // get_theme_mod
        $breadcrumb_hide_default = get_theme_mod('breadcrumb_hide_default', true);
        $breadcrumb_background = get_theme_mod('breadcrumb_background');
        $breadcrumb_info_switch = get_theme_mod('breadcrumb_info_switch', false);

        // Background Image
        if ($hide_bg_img && empty($_GET['s'])) {
            $breadcrumb_background = '';
        } else {
            $breadcrumb_background = !empty($bg_img_from_page) ? $bg_img_from_page['url'] : $breadcrumb_background;
        }

        // Breadcrumb Shape
        $breadcrumb_img = function_exists('get_field') ? get_field('breadcrumb_background_shape', $_id) : '';
        $hide_image = function_exists('get_field') ? get_field('hide_breadcrumb_background_shape', $_id) : '';
        $breadcrumb_shape = get_theme_mod('breadcrumb_shape');

        if ($hide_image && $_GET['s']) {
            $breadcrumb_shape = '';
        } else {
            $breadcrumb_shape = !empty($breadcrumb_img) ? $breadcrumb_img['url'] : $breadcrumb_shape;
        }

        $breadcrumb_full = empty($breadcrumb_shape) || is_single() && 'post' == get_post_type() || is_single() && 'services' == get_post_type() || is_single() && 'product' == get_post_type() ? 'col-12' : 'col-xl-6 col-lg-7';
?>

        <?php if (!empty($breadcrumb_hide_default)) : ?>
            <!-- breadcrumb-area -->
            <section class="breadcrumb-area <?php print esc_attr($breadcrumb_class); ?>" data-background="<?php echo esc_url($breadcrumb_background); ?>">
                <div class="container">
                    <div class="breadcrumb__wrapper">
                        <div class="row">
                            <div class="<?php echo esc_attr($breadcrumb_full); ?>">
                                <div class="breadcrumb__content">
                                    <h2 class="title"><?php echo wp_kses_post($title); ?></h2>
                                    <?php if (!empty($breadcrumb_info_switch)) : ?>
                                        <nav aria-label="breadcrumb" class="breadcrumb">
                                            <?php if (function_exists('bcn_display')) {
                                                bcn_display();
                                            } ?>
                                        </nav>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php if (!is_single()) : ?>
                                <?php if (!empty($breadcrumb_shape)) : ?>
                                    <div class="col-xl-6 col-lg-5 position-relative d-none d-lg-block">
                                        <div class="breadcrumb__img">
                                            <img src="<?php echo esc_url($breadcrumb_shape) ?>" alt="<?php print esc_attr__('Shape', 'mykd'); ?>">
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </section>
            <!-- breadcrumb-area-end -->
        <?php endif; ?>

<?php
    }
}

add_action('mykd_before_main_content', 'mykd_breadcrumb_func');
