<?php

/**
 * Template part for displaying offcanvas menu
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package mykd
 */

// Header Search
$mykd_show_header_search = get_theme_mod('mykd_show_header_search', false);
$mykd_search_title = get_theme_mod('mykd_search_title', __('Search Here', 'mykd'));

?>

<?php if (!empty($mykd_show_header_search)) : ?>
    <div class="search__popup-wrap">
        <div class="search__layer"></div>
        <div class="search__close">
            <span><i class="flaticon-swords-in-cross-arrangement"></i></span>
        </div>
        <div class="search__wrap text-center">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <?php if (!empty($mykd_search_title)) : ?>
                            <h2 class="title">... <span><?php echo esc_html($mykd_search_title) ?></span> ...</h2>
                        <?php endif; ?>
                        <div class="search__form">
                            <form method="get" action="<?php print esc_url(home_url('/')); ?>">
                                <input class="search-input-field" type="text" name="s" value="<?php print esc_attr(get_search_query()) ?>" placeholder="<?php print esc_attr__('Type keywords here', 'mykd'); ?>">
                                <button class="search-btn"><i class="flaticon-loupe"></i></button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>